<?php

class Vaisseau {
    private $nom;
    private $type;
    private $equipage = []; // Array of Personne
    private $jaugeVie;
    private $estPropre;
    private $estEnEtat;

    // 
    public function __construct($nom, $type, $pvMax) {
        $this->nom = $nom;
        $this->type = $type;
        $this->jaugeVie = $pvMax;
        $this->estPropre = true; // Starts clean
        $this->estEnEtat = true; // Starts working
    }

    // Getters and Setters
    public function getNom() { return $this->nom; }
    public function setNom($nom) { $this->nom = $nom; }
    public function getEquipage() { return $this->equipage; }
    public function setEtat($bool) { $this->estEnEtat = $bool; }
    public function setProprete($bool) { $this->estPropre = $bool; }

    // Add crew member
    public function ajouterMembre(Personne $personne) {
        if (count($this->equipage) >= 10) { // Max 10
            echo "Erreur : Vaisseau complet.<br>";
            return false;
        }
        foreach ($this->equipage as $membre) {
            if ($membre->getNom() === $personne->getNom()) { // Unique check
                echo "Erreur : Cette personne est déjà à bord.<br>";
                return false;
            }
        }
        $this->equipage[] = $personne;
        echo "Bienvenue à bord, " . $personne->getNom() . ".<br>";
        return true;
    }

    // Remove crew member
    public function retirerMembre($nomPersonne) {
        foreach ($this->equipage as $key => $membre) {
            if ($membre->getNom() === $nomPersonne) {
                unset($this->equipage[$key]);
                // Re-index array
                $this->equipage = array_values($this->equipage);
                return true;
            }
        }
        return false;
    }

    // Check readiness
    public function estPareADecoller() {
        $nbCrew = count($this->equipage);
        // Checks: 2-10 crew, clean, working
        if ($nbCrew >= 2 && $nbCrew <= 10 && $this->estPropre && $this->estEnEtat) {
            return true;
        }
        return false;
    }

    // Repair/Clean method
    public function remettreEnEtat() {
        // If dirty, need 'agent d'entretien'
        if (!$this->estPropre) {
            $hasCleaner = false;
            foreach ($this->equipage as $p) {
                if ($p instanceof Operateur && $p->getMetier() === 'agent d\'entretien') {
                    $hasCleaner = true;
                    $p->agir(); // Clean
                    break;
                }
            }
            if ($hasCleaner) $this->estPropre = true;
            else return 0; // Failure
        }

        // If broken, need 'agent de maintenance'
        if (!$this->estEnEtat) {
            $hasMechanic = false;
            foreach ($this->equipage as $p) {
                if ($p instanceof Operateur && $p->getMetier() === 'agent de maintenance') {
                    $hasMechanic = true;
                    $p->agir(); // Repair
                    break;
                }
            }
            if ($hasMechanic) $this->estEnEtat = true;
            else return 0; // Failure
        }

        return 1; // Success
    }

    // Take off
    public function decoller() {
        // 1. Check ready, if not, try to repair
        if (!$this->estPareADecoller()) {
            $this->remettreEnEtat();
        }

        // 2. Check again if ready
        if ($this->estPareADecoller()) {
            // 3. Check for Pilot
            $hasPilot = false;
            foreach ($this->equipage as $p) {
                if ($p instanceof Operateur && $p->getMetier() === 'pilote') {
                    $hasPilot = true;
                    $p->agir(); // Take off action
                    break;
                }
            }

            if ($hasPilot) return 1; // Success
        }
        
        return 0; // Failure
    }
}

// Fleet Class
class Flotte {
    private $nom;
    private $vaisseaux = [];

    public function __construct($nom) {
        $this->nom = $nom;
    }

    // Add/Remove logic
    public function ajouterVaisseau(Vaisseau $v) {
        $this->vaisseaux[] = $v;
    }

    public function retirerVaisseau($nomVaisseau) {
        foreach ($this->vaisseaux as $key => $v) {
            if ($v->getNom() === $nomVaisseau) {
                unset($this->vaisseaux[$key]);
                $this->vaisseaux = array_values($this->vaisseaux);
            }
        }
    }
}
?>