<?php
// api.php
require_once 'includes/db.php';

// CORRECTION ICI : On ne lance session_start que si nécessaire
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');
// ... le reste du code

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'msg' => 'Non connecté']);
    exit;
}

$game = new GameManager($link, $_SESSION['user_id']);
$action = $_POST['action'] ?? '';
$response = ['success' => false];

try {
    switch ($action) {
        case 'get_state':
            $response = ['success' => true];
            break;

        case 'move':
            $response = $game->move($_POST['id'], $_POST['x'], $_POST['y']);
            break;

        case 'attack':
            $response = $game->attack($_POST['attackerId'], $_POST['targetId']);
            break;

        case 'end_turn':
            $response = $game->endTurn();
            break;
            
        default:
            $response['msg'] = "Action inconnue";
    }
} catch (Exception $e) {
    $response['msg'] = $e->getMessage();
}

// Toujours renvoyer l'état du jeu mis à jour
$gameState = $game->getGameState();
$response['gameState'] = $gameState;

// Gestion Victoire / Défaite
if ($gameState['win'] === 'WIN') $response['msg'] = "VICTOIRE !";
if ($gameState['win'] === 'LOSE') $response['msg'] = "DÉFAITE...";

echo json_encode($response);
mysqli_close($link);
exit;