<?php
// action_game.php
require_once '../includes/db.php';
require_once '../GameEngine.php'; // Ensure this path is correct

if (session_status() === PHP_SESSION_NONE) { session_start(); }
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'msg' => 'Non connecté']);
    exit;
}

$my_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? '';
$response = ['success' => false];

// Instantiate Game Engine
$game = new GameManager($link, $my_id);

try {
    switch ($action) {
        
        // ==========================================
        // LOBBY ACTIONS
        // ==========================================
        
        case 'check_lobby_status':
            // Replaces lobby_status.php
            $sql = "SELECT ready, opponent_id FROM user_profiles WHERE user_id = $my_id";
            $res = mysqli_query($link, $sql);
            if ($res && mysqli_num_rows($res) > 0) {
                $data = mysqli_fetch_assoc($res);
                $response = [
                    'success' => true,
                    'am_i_ready' => (int)$data['ready'],
                    'opponent_id' => $data['opponent_id']
                ];
            } else {
                $response = ['success' => true, 'am_i_ready' => 0, 'opponent_id' => null];
            }
            break;

        case 'get_radar':
            // Replaces get_ready_players.php
            $sql = "SELECT u.login_user, p.user_id 
                    FROM user_profiles p 
                    JOIN users u ON p.user_id = u.id_user 
                    WHERE p.ready = 1 AND p.opponent_id IS NULL";
            $result = mysqli_query($link, $sql);
            $players = [];
            while ($row = mysqli_fetch_assoc($result)) {
                $row['is_me'] = ($row['user_id'] == $my_id);
                $players[] = $row;
            }
            $response = ['success' => true, 'players' => $players];
            break;

        case 'join_lobby':
            // Replaces lobby_action.php (action=play)
            $fleet_data = $_POST['fleet'] ?? []; // Expecting array from AJAX
            
            // 1. Check Wins
            $qUser = mysqli_query($link, "SELECT victoires FROM user_profiles WHERE user_id = $my_id");
            $user_wins = (int)mysqli_fetch_assoc($qUser)['victoires'];

            if (is_array($fleet_data) && count($fleet_data) === 5) {
                mysqli_query($link, "DELETE FROM user_fleets WHERE user_id = $my_id");
                
                foreach ($fleet_data as $ship_obj) {
                    $ship_id = (int)$ship_obj['ship_id']; // Ensure JS sends 'ship_id'
                    
                    $res_ship = mysqli_query($link, "SELECT points_vie, type, victoires_necessaire FROM vaisseaux WHERE id = $ship_id");
                    $data_ship = mysqli_fetch_assoc($res_ship);
                    
                    if ($data_ship) {
                        if ($user_wins < (int)$data_ship['victoires_necessaire']) {
                            mysqli_query($link, "DELETE FROM user_fleets WHERE user_id = $my_id");
                            echo json_encode(['success' => false, 'msg' => "Triche détectée."]);
                            exit;
                        }
                        $hp = $data_ship['points_vie'];
                        $type = mysqli_real_escape_string($link, $data_ship['type']);
                        $sql = "INSERT INTO user_fleets (user_id, vaisseau_id, current_hp, energy, coord_x, coord_y, type_ship) 
                                VALUES ($my_id, $ship_id, $hp, 100, -1, -1, '$type')"; // -1 until match starts
                        mysqli_query($link, $sql);
                    }
                }

                // Set Ready
                mysqli_query($link, "UPDATE user_profiles SET ready = 1, opponent_id = NULL WHERE user_id = $my_id");

                // Matchmaking Logic
                $sql_match = "SELECT user_id FROM user_profiles WHERE ready = 1 AND opponent_id IS NULL AND user_id != $my_id LIMIT 1";
                $res_match = mysqli_query($link, $sql_match);

                if (mysqli_num_rows($res_match) > 0) {
                    $opp_id = mysqli_fetch_assoc($res_match)['user_id'];
                    
                    // Link players
                    mysqli_query($link, "UPDATE user_profiles SET opponent_id = $opp_id, is_my_turn = 1 WHERE user_id = $my_id");
                    mysqli_query($link, "UPDATE user_profiles SET opponent_id = $my_id, is_my_turn = 0 WHERE user_id = $opp_id");

                    // Position Ships
                    $y_pos = range(0, 9); shuffle($y_pos);
                    $my_f = mysqli_query($link, "SELECT id FROM user_fleets WHERE user_id = $my_id");
                    $i=0; while($f=mysqli_fetch_assoc($my_f)) { 
                        mysqli_query($link, "UPDATE user_fleets SET coord_x=0, coord_y={$y_pos[$i++]} WHERE id={$f['id']}"); 
                    }

                    shuffle($y_pos);
                    $op_f = mysqli_query($link, "SELECT id FROM user_fleets WHERE user_id = $opp_id");
                    $j=0; while($f=mysqli_fetch_assoc($op_f)) { 
                        mysqli_query($link, "UPDATE user_fleets SET coord_x=9, coord_y={$y_pos[$j++]} WHERE id={$f['id']}"); 
                    }
                }
                $response = ['success' => true];
            } else {
                $response = ['success' => false, 'msg' => 'Flotte invalide'];
            }
            break;

        case 'cancel_lobby':
             mysqli_query($link, "UPDATE user_profiles SET ready = 0 WHERE user_id = $my_id");
             $response = ['success' => true];
             break;

        // ==========================================
        // GAMEPLAY ACTIONS (Proxy to GameManager)
        // ==========================================

        case 'get_state': 
            $response['success'] = true; 
            break; // State is attached below

        case 'move': 
            $response = $game->move((int)$_POST['id'], (int)$_POST['x'], (int)$_POST['y']); 
            break;
        case 'attack': 
            $response = $game->attack((int)$_POST['attackerId'], (int)$_POST['targetId']); 
            break;
        case 'spawn_drone': 
            $response = $game->spawnDrone((int)$_POST['parentId'], $_POST['type'], (int)$_POST['x'], (int)$_POST['y']); 
            break;
        case 'explode': 
            $response = $game->explodeDrone((int)$_POST['droneId']);
            break;
        case 'heal': 
            $response = $game->heal((int)$_POST['healerId'], (int)$_POST['targetId']); 
            break;
        case 'end_turn': 
            $response = $game->endTurn(); 
            break;
        case 'surrender': 
            $response = $game->surrender(); 
            break;
        case 'quit': 
            $response = $game->quit(); 
            break;
    }

} catch (Exception $e) {
    $response = ['success' => false, 'msg' => $e->getMessage()];
}

// Always attach GameState if we are in game context or checking state
if ($action !== 'get_radar' && $action !== 'check_lobby_status') {
    $response['gameState'] = $game->getGameState();
}

echo json_encode($response);
?>