<?php
// api.php
require_once 'includes/db.php';

// Chargement automatique ou manuel de la classe
if (file_exists('GameEngine.php')) require_once 'GameEngine.php';
else require_once 'GameEngine.php';

if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) { echo json_encode(['success' => false, 'msg' => 'Non connecté']); exit; }

$game = new GameManager($link, $_SESSION['user_id']);
$action = $_POST['action'] ?? '';
$response = ['success' => false];

try {
    switch ($action) {
        // --- ETAT DU JEU ---
        case 'get_state': 
            $response['success'] = true; 
            break;

        // --- ACTIONS BASIQUES ---
        case 'move': 
            $response = $game->move((int)$_POST['id'], (int)$_POST['x'], (int)$_POST['y']); 
            break;
        case 'attack': 
            $response = $game->attack((int)$_POST['attackerId'], (int)$_POST['targetId']); 
            break;
        case 'spawn_drone': 
            $response = $game->spawnDrone((int)$_POST['parentId'], $_POST['type'], (int)$_POST['x'], (int)$_POST['y']); 
            break;

        // --- ACTIONS SPÉCIALES ---
        case 'explode': // Pour le Kamikaze
            $response = $game->explodeDrone((int)$_POST['droneId']);
            break;
        case 'heal': // Pour le Soigneur
            $response = $game->heal((int)$_POST['healerId'], (int)$_POST['targetId']); 
            break;

        // --- GESTION PARTIE ---
        case 'end_turn': $response = $game->endTurn(); break;
        case 'surrender': $response = $game->surrender(); break;
        case 'quit': $response = $game->quit(); break;

        default: $response['msg'] = "Action inconnue"; break;
    }
} catch (Exception $e) { $response['msg'] = "Erreur: " . $e->getMessage(); }

// Récupération de l'état final après l'action
$gameState = $game->getGameState();
$response['gameState'] = $gameState;

echo json_encode($response);
exit;