<!DOCTYPE html>
    <html lang="fr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Page d'Accueil</title>
        <style>
            /* Réinitialiser les marges et les paddings par défaut */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Style global de la page */
body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f4;
    color: #333;
    padding: 20px;
}

h1 {
    color: #2c3e50;
    margin-bottom: 20px;
    text-align: center;
}

/* Style du formulaire */
form {
    background-color: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    max-width: 600px;
    margin: 0 auto;
}

label {
    font-weight: bold;
    display: block;
    margin-bottom: 8px;
    font-size: 14px;
}

input[type="text"],
input[type="date"],
input[type="number"],
select,
input[type="file"] {
    width: 100%;
    padding: 10px;
    margin: 8px 0;
    border: 1px solid #ccc;
    border-radius: 4px;
    font-size: 14px;
}

.black {
    background-color: black;
    color: white;
    border: solid;
    border-color: white;
    padding: 10px 15px;
    cursor: pointer;
    font-size: 16px;
    border-radius: 4px;
    transition: background-color 0.3s ease;
}

.green {
    background-color: green;
    color: white;
    border: solid;
    border-color: white;
    padding: 10px 15px;
    cursor: pointer;
    font-size: 16px;
    border-radius: 4px;
    transition: background-color 0.3s ease;
}

.red {
    background-color: red;
    color: white;
    border: solid;
    border-color: white;
    padding: 10px 15px;
    cursor: pointer;
    font-size: 16px;
    border-radius: 4px;
    transition: background-color 0.3s ease;
}

input[type="submit"]:hover {
    background-color: white;
    color: black;
    border-color: black;
}

/* Style personnalisé pour les checkboxes */
input[type="checkbox"] {
    appearance: none;
    -webkit-appearance: none;
    width: 20px;
    height: 20px;
    border: 2px solid #444;
    border-radius: 4px;
    background-color: white;
    cursor: pointer;
    transition: all 0.2s ease-in-out;
    position: relative;
}

input[type="checkbox"]:checked {
    background-color: #4CAF50;
    border-color: #4CAF50;
}

input[type="checkbox"]::after {
    content: '';
    display: none;
}

input[type="checkbox"]:checked::after {
    display: block;
    color: white;
    font-weight: bold;
    position: absolute;
}


/* Tableau des réalisations */
table {
    width: 100%;
    margin-top: 20px;
    border-collapse: collapse;
}

table, th, td {
    border: 1px solid #ccc;
}

th, td {
    padding: 12px;
    text-align: center;
    font-size: 14px;
}

th {
    background-color: #2c3e50;
    color: white;
}

td img {
    width: 100px;
    height: auto;
    border-radius: 4px;
}

/* Messages d'alerte */
p {
    text-align: center;
    font-size: 16px;
    color: #e74c3c;
    margin-top: 20px;
}

h1 + p {
    color: #27ae60;
}

        </style>
    </head>
    <body>
        <h1>Interface d'Accueil - Administration</h1>
        <form method="POST">
            <label for="operation">Choisir une opération :</label>
            <select name="operation" id="operation">
                <option value="afficher">Afficher les données</option>
                <option value="insertion">Ajouter une réalisation</option>
                <option value="suppression">Supprimer une réalisation</option>
            </select>
            <input class="black" type="submit" value="Soumettre">
        </form>
        <?php

        function inserer_realisation($matiere,$date,$image){
            $link = mysqli_connect("localhost","mathieuprosper_admin","RE15om!+2615","mathieuprosper_DataBase") ;
            mysqli_query($link, "INSERT Into Realisations(Matiere,Date,Image) VALUES('$matiere','$date','$image');") or die(mysqli_error($link));
        }
        
        function supprimer_realisation($id){
            $link = mysqli_connect("localhost","mathieuprosper_admin","RE15om!+2615","mathieuprosper_DataBase") ;
            mysqli_query($link, "DELETE FROM `Realisations` WHERE Id = $id;") or die(mysqli_error($link));
        }
        
        function supprimer_tout(){
            $link = mysqli_connect("localhost","mathieuprosper_admin","RE15om!+2615","mathieuprosper_DataBase");
            mysqli_query($link, "DELETE FROM `Realisations`") or die(mysqli_error($link));
            
            $dossier = 'Images/';
            $fichiers = glob($dossier . '*');
            
            if ($fichiers !== false) {
                foreach ($fichiers as $fichier) {
                    if (is_file($fichier)) {
                        unlink($fichier);
                    }
                }
            }
        }
        
        function afficher_realisations($sortby, $direction,$action) {
            $amount = 0;
            $link = mysqli_connect("localhost", "mathieuprosper_admin", "RE15om!+2615", "mathieuprosper_DataBase");
            $query = "SELECT Id, Matiere, Date, Image FROM Realisations ORDER BY $sortby $direction";
            $res = mysqli_query($link, $query);
            
            echo "<br><br><form method='POST'><table>";
            if ($action=="supp") {
                echo "<input class='red' type='submit' value='Suprrimer selectioner'>";
            }
            echo "<tr>";
            if ($action=="supp") {
                echo "<td>Selectionner</td>";
            }
            echo "
            <td>Id</td>
            <td>Matiere</td>
            <td>Date</td>
            <td>Image</td>
            </tr>";

            while ($projet = mysqli_fetch_assoc($res)){
            echo "<tr>";
                if ($action=="supp") {
                    echo "<td><input type='checkbox' id='$projet[Id]' name='$projet[Id]' value='$projet[Id]'></td>";
                }
                foreach($projet as $indice => $valeur){
                    if ($indice == "Image") {
                        echo "<td><img src='Images/$valeur' style='width: 100px; height: auto;'></td>";    
                    } else {
                        echo "<td>$valeur</td>";
                    }
                }
                echo "</tr>";
                $amount += 1;
            }
            echo "</table></form>";
        
            if ($amount == 0) {
                echo "<p>Aucune donnée à afficher</p>";
            }
        }
        
        function countimage($imageName) {
            $link = mysqli_connect("localhost", "mathieuprosper_admin", "RE15om!+2615", "mathieuprosper_DataBase");
            $query = "SELECT COUNT(*) as count FROM Realisations WHERE Image = '$imageName'";
            $res = mysqli_query($link, $query);
            $row = mysqli_fetch_assoc($res);
            return $row['count'];
        }
        
        if (isset($_POST['operation'])) {
            $operation = $_POST['operation'];
            if ($operation == 'afficher') {
            echo "
            <br><h1>Trier la table</h1>
            <form method='POST'>
              <br>
              <label for='sort'>Choisir une colonne</label>
              <select name='sort' id='sort'>
                <option value='id'>ID</option>
                <option value='matiere'>Matiere</option>
                <option value='date'>Date</option>
              </select>
              <br>
              <input type='radio' id='ASC' name='order' value='ASC' checked>
              <label for='ASC'>Ascendant</label>
              <input type='radio' id='DESC' name='order' value='DESC'>
              <label for='DESC'>Descendant</label>
              <br>
              <input class='black' type='submit' value='Trier'>
            </form>
            ";
            afficher_realisations("Id","ASC","aff");
            
            }   elseif ($operation == 'insertion') {
                echo "<br><h1>Ajouter une nouvelle réalisation</h1>";
                echo "<form method='POST' action='' enctype='multipart/form-data'>";
                echo "<label for='Matiere'>Matiere: </label>";
                echo "<input type='text' name='Matiere' id='Matiere' required /><br><br>";
                echo "<label for='Date'>Date: </label>";
                echo "<input type='date' id='Date' name='Date'><br><br>";
                echo "<input type='file' id='Image' name='Image' accept='image/png, image/jpeg'/><br><br>";
                echo "<input class='green' type='submit' value='Ajouter' />";
                echo "</form>";
                
            }   elseif ($operation == 'suppression') {
                echo "<br><h1>Supprimer une réalisation</h1>";
                echo "<form method='POST' action=''>"; 
                echo "<label for='Id'>Id: </label>";
                echo "<input type='number' name='Id' id='Id' required value='0'/>";
                echo "<label for='Wipe'>Tout supprimer: </label>";
                echo "<input type='checkbox' name='Wipe' id='Wipe' /><br><br>";
                echo "<input class='red' type='submit' value='Supprimer' />";
                echo "</form>";
                afficher_realisations("Id","ASC","supp");
            } 
        }
        
        if (isset($_POST['sort']) && isset($_POST['order'])) {
            echo "
            <br><h1>Trier la table</h1>
            <form method='POST'>
              <br>
              <label for='sort'>Choisir une colonne</label>
              <select name='sort' id='sort'>
                <option value='id'>ID</option>
                <option value='matiere'>Matiere</option>
                <option value='date'>Date</option>
              </select>
              <br>
              <input type='radio' id='ASC' name='order' value='ASC' checked>
              <label for='ASC'>Ascendant</label>
              <input type='radio' id='DESC' name='order' value='DESC'>
              <label for='DESC'>Descendant</label>
              <br>
              <input class='black' type='submit' value='Trier'>
            </form>
            ";
            afficher_realisations($_POST['sort'], $_POST['order'],"aff");
        }
        
        if (isset($_POST['Matiere']) && isset($_POST['Date']) && isset($_FILES['Image'])) {
            $image = $_FILES['Image'];
            if ($image['error'] === 0) {
                $target_file = "Images/" . basename($image["name"]); 
                if (!file_exists($target_file)) {
                    if (move_uploaded_file($image["tmp_name"], $target_file)) {
                        echo "<br><h1>Realisation ajouter</h1>";            
                    }   
                }
                inserer_realisation($_POST['Matiere'], $_POST['Date'], $image["name"]);
                afficher_realisations("Id","ASC","aff");
            } else {
                echo "<h1>Code d'erreur: " . $image['error'] . "</h1>";
            }
        }
        
        if (isset($_POST['Id'])) {
            if (isset($_POST['Wipe'])) {
                if ($_POST['Wipe'] == true) {
                    supprimer_tout();
                    afficher_realisations("Id","ASC","supp");
                }
            } else {
                supprimer_realisation($_POST['Id']);
                echo "<br><h1>Supprimer une réalisation</h1>";
                echo "<form method='POST' action=''>"; 
                echo "<label for='Id'>Id: </label>";
                echo "<input type='number' name='Id' id='Id' required value='0'/>";
                echo "<label for='Wipe'>Tout supprimer: </label>";
                echo "<input type='checkbox' name='Wipe' id='Wipe' /><br><br>";
                echo "<input class='red' type='submit' value='Supprimer' />";
                echo "</form>";
                afficher_realisations("Id","ASC","supp");
            }
        }
        
        $link = mysqli_connect("localhost", "mathieuprosper_admin", "RE15om!+2615", "mathieuprosper_DataBase");
        $query = "SELECT Id, Matiere, Date, Image FROM Realisations ORDER BY Id";
        $res = mysqli_query($link, $query);
        $didujustdeletedsomething = false;
        
        while ($projet = mysqli_fetch_assoc($res)){
            foreach($projet as $indice => $valeur){
                if (isset($_POST[$projet['Id']])) {
                    $file_to_delete = "Images/" . $projet['Image'];
                    if (countimage($projet['Image']) <= 1 && $didujustdeletedsomething == false) {
                        if (file_exists($file_to_delete)) {
                            unlink($file_to_delete);
                        }
                    }
                    supprimer_realisation($projet['Id']);
                    $didujustdeletedsomething = true;
                }
            }
        }
        
        if ($didujustdeletedsomething == true) {
            afficher_realisations("Id","ASC","supp");
        }
        
        ?>
</body>
</html>
